/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.google.inject.Inject;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.RenderingOptions;

public class DebugRenderer {
    private final RenderingOptions renderingOptions;
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();
    private final DebugWindow debugWindow;

    @Inject
    public DebugRenderer(RenderingOptions renderingOptions, DebugWindow debugWindow) {
        this.renderingOptions = renderingOptions;
        this.debugWindow = debugWindow;
    }

    public void render(TiledMap worldMap, OrthographicCamera camera) {
        this.debugWindow.render();
        if (this.renderingOptions.debug().showPathfindingNodes()) {
            this.shapeRenderer.setProjectionMatrix(camera.combined);
        }
    }
}

